//
//  URLLoader.h
//  Mensa
//  
//  The URL loader allows simple loading of web-based (HTTP) resources. The response is delivered via a block
//  Optionally, a cache can be supplied to automatically cache the response of a request.
//
//  Created by Jonathan Diehl on 20.12.10.
//  Copyright 2010 RWTH. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void (^URLLoaderHandler)(NSData *response, NSError *error);


@interface URLLoader : NSObject {
	URLLoaderHandler handler;
	NSURLRequest *request;
	NSURLConnection *connection;
	NSMutableData *data;
}

+ (id)loadRequest:(NSURLRequest *)aRequest handler:(URLLoaderHandler)aHandler;
+ (id)loadURL:(NSURL *)url handler:(URLLoaderHandler)aHandler;

- (id)initWithRequest:(NSURLRequest *)aRequest handler:(URLLoaderHandler)aHandler;
- (id)initWithURL:(NSURL *)url handler:(URLLoaderHandler)aHandler;

- (void)start;
- (void)cancel;

@end
